<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('dashboard')); ?>" class="brand-link">
        <div style="display: flex;justify-content: center">
            <?php if(!empty($all_settings->logo_path)): ?>
                <img src="<?php echo e(asset('logos/' . $all_settings->logo_path)); ?>" alt="Company Logo" width="150">
            <?php else: ?>
                <img src="<?php echo e(asset('logos/default/default-logo.gif')); ?>" alt="Default Logo" width="150">
            <?php endif; ?>
        </div>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="info">
                <a href="<?php echo e(route('system.update')); ?>" class="d-block" style="font-weight: 600; font-size: 16px; letter-spacing: 0.5px;">VECTOR MANAGEMENT V1.0</a>
            </div>
        </div>

        <!-- SidebarSearch Form -->
        <div class="form-inline">
            <div class="input-group" data-widget="sidebar-search">
                <input class="form-control form-control-sidebar" type="search" placeholder="Search"
                    aria-label="Search">
                <div class="input-group-append">
                    <button class="btn btn-sidebar">
                        <i class="fas fa-search fa-fw"></i>
                    </button>
                </div>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu"
                data-accordion="false">

                <!-- Dashboard -->
                <li class="nav-item">
                    <a href="<?php echo e(route('dashboard')); ?>" class="nav-link <?php echo e(Route::is('dashboard') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>Dashboard</p>
                    </a>
                </li>

                <!-- POS Terminal -->
                <li class="nav-item">
                    <a href="<?php echo e(route('pos.dashboard')); ?>" class="nav-link <?php echo e(Route::is('pos.dashboard') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-cash-register"></i>
                        <p>POS Terminal</p>
                    </a>
                </li>

                <!-- Sales Management -->
                <li class="nav-item">
                    <a href="<?php echo e(route('sales.index')); ?>" class="nav-link <?php echo e(Route::is('sales.index') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-bar"></i>
                        <p>Sales Management</p>
                    </a>
                </li>

                <!-- Customer Tracking -->
                <li class="nav-item">
                    <a href="<?php echo e(route('customer.index')); ?>"
                        class="nav-link <?php echo e(Route::is('customer.index') || Route::is('customers.credits') || Route::is('customer.show') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-users"></i>
                        <p>Customer Tracking</p>
                    </a>
                </li>

                <!-- Product -->
                <li class="nav-item has-treeview <?php echo e(Route::is('product.*') && !Route::is('product.stock.report') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link <?php echo e(Route::is('product.*') && !Route::is('product.stock.report') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-box"></i>
                        <p>
                            Product
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('product.create')); ?>"
                                class="nav-link <?php echo e(Route::is('product.create') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Add Product</p>
                                <span class="right badge badge-danger">New</span>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('product.index')); ?>"
                                class="nav-link <?php echo e(Route::is('product.index') || Route::is('product.show') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Product List</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('product.stock')); ?>"
                                class="nav-link <?php echo e(Route::is('product.stock') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Stock Overview</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Expense -->
                <li class="nav-item has-treeview <?php echo e(Route::is('expenses.*') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link <?php echo e(Route::is('expenses.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-money-bill-wave"></i>
                        <p>
                            Expense
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('expenses.create')); ?>"
                                class="nav-link <?php echo e(Route::is('expenses.create') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Add Expense</p>
                                <span class="right badge badge-danger">New</span>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Reports -->
                <li class="nav-item has-treeview <?php echo e(Route::is('sales.history') || Route::is('sale.index') || Route::is('direct-sales.index') || Route::is('report.index') || Route::is('sales.profit.report') || Route::is('expenses.report') || Route::is('report.netprofit') || Route::is('product.stock.report') ? 'menu-open' : ''); ?>">
                    <a href="#" class="nav-link <?php echo e(Route::is('sales.history') || Route::is('sale.index') || Route::is('direct-sales.index') || Route::is('report.index') || Route::is('sales.profit.report') || Route::is('expenses.report') || Route::is('report.netprofit') || Route::is('product.stock.report') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-chart-line"></i>
                        <p>
                            Reports
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('sales.history')); ?>" class="nav-link <?php echo e(Route::is('sales.history') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Sales History</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('sale.index')); ?>" class="nav-link <?php echo e(Route::is('sale.index') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Sales</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('direct-sales.index')); ?>"
                                class="nav-link <?php echo e(Route::is('direct-sales.index') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Direct Sales Report</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('report.index')); ?>"
                                class="nav-link <?php echo e(Route::is('report.index') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Profit Reports</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('expenses.report')); ?>"
                                class="nav-link <?php echo e(Route::is('expenses.report') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Expense Report</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('report.netprofit')); ?>"
                                class="nav-link <?php echo e(Route::is('report.netprofit') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Manage Profit</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('product.stock.report')); ?>"
                                class="nav-link <?php echo e(Route::is('product.stock.report') ? 'active' : ''); ?>">
                                <i class="far fa-chart-bar nav-icon"></i>
                                <p>Product Stock Report</p>
                                <span class="right badge badge-success">New</span>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Master Data (Brands & Models) -->
                <li class="nav-item has-treeview <?php echo e(Route::is('brands.*') || Route::is('mobile-models.*') ? 'menu-open' : ''); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(Route::is('brands.*') || Route::is('mobile-models.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-database"></i>
                        <p>
                            Master Data
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('brands.index')); ?>"
                                class="nav-link <?php echo e(Route::is('brands.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Brands</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('mobile-models.index')); ?>"
                                class="nav-link <?php echo e(Route::is('mobile-models.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Mobile Models</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- User Management -->
                <li class="nav-item has-treeview <?php echo e(Route::is('users.*') || Route::is('roles.*') || Route::is('permissions.*') || Route::is('tenants.*') ? 'menu-open' : ''); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(Route::is('users.*') || Route::is('roles.*') || Route::is('permissions.*') || Route::is('tenants.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-user-shield"></i>
                        <p>
                            User Management
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('users.index')); ?>"
                                class="nav-link <?php echo e(Route::is('users.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Users</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('roles.index')); ?>"
                                class="nav-link <?php echo e(Route::is('roles.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Roles</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('permissions.index')); ?>"
                                class="nav-link <?php echo e(Route::is('permissions.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Permissions</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('tenants.index')); ?>"
                                class="nav-link <?php echo e(Route::is('tenants.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Tenants</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Settings -->
                <li class="nav-item has-treeview <?php echo e(Route::is('settings.*') || Route::is('invoice-settings.*') || Route::is('whatsapp.*') ? 'menu-open' : ''); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(Route::is('settings.*') || Route::is('invoice-settings.*') || Route::is('whatsapp.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-cogs"></i>
                        <p>
                            Settings
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('settings.index')); ?>"
                                class="nav-link <?php echo e(Route::is('settings.index') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>General Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('invoice-settings.index')); ?>"
                                class="nav-link <?php echo e(Route::is('invoice-settings.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Invoice Settings</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('whatsapp.management')); ?>"
                                class="nav-link <?php echo e(Route::is('whatsapp.management') ? 'active' : ''); ?>">
                                <i class="fab fa-whatsapp nav-icon text-success"></i>
                                <p>WhatsApp Management</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('whatsapp.web.connect')); ?>"
                                class="nav-link <?php echo e(Route::is('whatsapp.web.connect') ? 'active' : ''); ?>">
                                <i class="fas fa-qrcode nav-icon text-info"></i>
                                <p>WhatsApp Web</p>
                            </a>
                        </li>
                    </ul>
                </li>

                <!-- Subscription Management (Admin Only) -->
                <?php if(auth()->user()->hasRole('admin') || auth()->user()->hasRole('super-admin')): ?>
                <li class="nav-item has-treeview <?php echo e(Route::is('plans.*') || Route::is('subscriptions.*') ? 'menu-open' : ''); ?>">
                    <a href="#"
                        class="nav-link <?php echo e(Route::is('plans.*') || Route::is('subscriptions.*') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-credit-card"></i>
                        <p>
                            Subscription Management
                            <i class="right fas fa-angle-left"></i>
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('plans.index')); ?>"
                                class="nav-link <?php echo e(Route::is('plans.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Plans</p>
                            </a>
                        </li>
                        <li class="nav-item">
                            <a href="<?php echo e(route('subscriptions.index')); ?>"
                                class="nav-link <?php echo e(Route::is('subscriptions.*') ? 'active' : ''); ?>">
                                <i class="far fa-circle nav-icon"></i>
                                <p>Subscriptions</p>
                            </a>
                        </li>
                    </ul>
                </li>
                <?php endif; ?>

            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/pos24.3/resources/views/layouts/sidebar.blade.php ENDPATH**/ ?>